<?php

    /*
     * Classe per la gestione degli utenti, dalla registrazione al
     */
    class GestoreUtenti {
        private $db;
        private $nomeTabella;
        private $prefissoPassword;
        private $algoritmoCifratura;
        
        /*
         * Il costruttore di questa classe prende in input un array
         * dove vengono specificati:
         * 
         * nomeTabella
         * prefissoPassword
         * algoritmoCifratura
         */
        function __construct($db, $datiGestoreLogin) {
            $this->db = $db;
            $this->nomeTabella        = $datiGestoreLogin["nomeTabella"];
            $this->prefissoPassword   = $datiGestoreLogin["prefissoPassword"];
            $this->algoritmoCifratura = $datiGestoreLogin["algoritmoCifratura"];
        }
        
        function login($email,$password) {
            $passwordHash = hash($this->algoritmoCifratura,$this->prefissoPassword.$password);
            $query = "SELECT * FROM $this->nomeTabella WHERE email LIKE '$email' AND password LIKE '$passwordHash'";
            $ris = $this->db->eseguiQueryLettura($query);
            if($ris->num_rows>0) {
                return $ris->fetch_assoc();
            }
            else {
                return null;
            }
        }
        
        /*
         * metodo che registra un nuovo utente nel database
         * Controlla prima se la mail inserita è già in uso, in tal caso restituisce -1
         * Se la creazione è andata a buon fine viene restituito l'id
         */
        function registrazioneUtente($ruolo,$stato,$nome,$cognome,$email,$password) {
            if($this->db->contaRigheTabella($this->nomeTabella,"email",$email)==0) {
                $dataCreazione= date("Y-m-d");
                $passwordHash = hash($this->algoritmoCifratura,$this->prefissoPassword.$password);
                $query = "INSERT INTO $this->nomeTabella (`id`,`ruolo`,`stato`,`email`,`password`,`nome`,`cognome`,`dataCreazione`) "
                        . "VALUES(NULL,'$ruolo','$stato','$email','$passwordHash','$nome','$cognome','$dataCreazione')";
                return$this->db->eseguiQueryCreazione($query);
            }
            else {
                return -1;
            }
        }
        
        function logout() {
            
        }
        
        function getDb() {
            return $this->db;
        }

        function getNomeTabella() {
            return $this->nomeTabella;
        }

        function setDb($db) {
            $this->db = $db;
        }

        function setNomeTabella($nomeTabella) {
            $this->nomeTabella = $nomeTabella;
        }
    }